<?php
// getContacts.php
header('Content-Type: application/json');
require_once '../db.php';

try {
    $stmt = $conn->prepare("
        SELECT 
            m1.fromPhoneNumber AS phone,
            MAX(m1.timestamp) AS lastMessageTime,
            (
                SELECT text 
                FROM WhatsAppMessages m2 
                WHERE m2.fromPhoneNumber = m1.fromPhoneNumber 
                  AND m2.text IS NOT NULL AND m2.text != ''
                ORDER BY m2.timestamp DESC
                LIMIT 1
            ) AS lastMessage
        FROM WhatsAppMessages m1
        GROUP BY m1.fromPhoneNumber
        ORDER BY lastMessageTime DESC
    ");
    $stmt->execute();
    $contacts = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($contacts);
} catch (Exception $e) {
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
}
