// document.addEventListener('DOMContentLoaded', () => {
//   loadContacts();
// });

document.addEventListener("DOMContentLoaded", function () {
    loadContacts();
});




let currentOffset = 0;
let currentSearch = "";
let isLoading = false;
const limit = 30;

// Load contacts with offset & optional search
function loadContacts(offset = 0, search = '', append = false) {
    if (isLoading) return;
    isLoading = true;

    fetch(`../api/getContacts.php?offset=${offset}&limit=${limit}&search=${encodeURIComponent(search)}`)
        .then(res => res.json())
        .then(data => {
            if (data.status === 'true') {
                const contactsContainer = document.getElementById("contacts");
                if (!append) contactsContainer.innerHTML = '';

                data.data.forEach(contact => {
                    const div = document.createElement("div");
                    div.classList.add("contact-item");
                    div.innerHTML = `
                        <strong>${contact.fullName || 'Unnamed'}</strong><br>
                        <span>${contact.mobile}</span>
                    `;
                    div.addEventListener("click", () => {
                        loadChatForContact(contact.mobile, contact.fullName);
                    });
                    contactsContainer.appendChild(div);
                });

                if (data.data.length > 0) {
                    currentOffset += data.data.length;
                }
            } else {
                console.error("Error loading contacts:", data.error);
            }
        })
        .catch(err => console.error("Fetch error:", err))
        .finally(() => {
            isLoading = false;
        });
}

// 🔍 Search on button click
document.getElementById("searchBtn").addEventListener("click", () => {
    currentOffset = 0;
    currentSearch = document.getElementById("searchInput").value.trim();
    loadContacts(0, currentSearch, false);
});

// 🧭 Infinite scroll
document.getElementById("contacts").addEventListener("scroll", function () {
    if (this.scrollTop + this.clientHeight >= this.scrollHeight - 10) {
        loadContacts(currentOffset, currentSearch, true);
    }
});

// Initial load
loadContacts();


// Mock function for future chat loading
function loadChatForContact(mobile, name) {
    document.getElementById("chat-header").innerText = `Chat with ${name} (${mobile})`;
    document.getElementById("chat-messages").innerHTML = "<p>Loading chat...</p>";
    // TODO: Call API to fetch messages and show in chat-messages div
}


function loadMessages(phone, name) {
  document.getElementById('chatHeader').textContent = `Chat with ${name}`;
  fetch(`../api/getMessages.php?phone=${phone}`)
    .then(res => res.json())
    .then(data => {
      const msgContainer = document.getElementById('messagesList');
      msgContainer.innerHTML = '';
      data.forEach(msg => {
        const div = document.createElement('div');
        div.className = `message ${msg.direction === 'sent' ? 'sent' : 'received'}`;
        div.innerHTML = `
          <div>${msg.text || msg.fileName || '[Media]'}</div>
          <div class="timestamp">${msg.timestamp}</div>
        `;
        msgContainer.appendChild(div);
      });
    });
}
