let selectedPhone = "";

document.addEventListener("DOMContentLoaded", () => {
  loadContacts();

  document.getElementById("send-btn").addEventListener("click", () => {
    const msg = document.getElementById("message-input").value.trim();
    if (msg && selectedPhone) {
      sendMessage(selectedPhone, msg);
    }
  });
});

function loadContacts() {
  // Dummy contacts — Replace this with API call if needed
  const contacts = ["918888888888", "919999999999"];
  const ul = document.getElementById("contact-list");

  contacts.forEach(phone => {
    const li = document.createElement("li");
    li.textContent = phone;
    li.style.cursor = "pointer";
    li.onclick = () => {
      selectedPhone = phone;
      loadMessages(phone);
    };
    ul.appendChild(li);
  });
}

function loadMessages(phone) {
  fetch(`/api/getMessages.php?phone=${phone}`)
    .then(res => res.json())
    .then(data => {
      const chat = document.getElementById("chat-window");
      chat.innerHTML = "";
      data.forEach(msg => {
        const div = document.createElement("div");
        div.className = "message " + (msg.isIncoming == 1 ? "incoming" : "outgoing");
        div.textContent = msg.text || "[Media]";
        chat.appendChild(div);
      });
    });
}

function sendMessage(phone, text) {
  fetch("/api/sendMessage.php", {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify({ to: phone, text })
  })
  .then(res => res.json())
  .then(resp => {
    if (resp.status === "success") {
      document.getElementById("message-input").value = "";
      loadMessages(phone); // Reload chat
    } else {
      alert("Failed to send");
    }
  });
}


function loadContactsO() {
  const ul = document.getElementById("contact-list");
  ul.innerHTML = "";

  fetch("/api/getContacts.php")
    .then(res => res.json())
    .then(contacts => {
      contacts.forEach(contact => {
        const li = document.createElement("li");
        li.textContent = contact.phone;
        li.style.cursor = "pointer";
        li.onclick = () => {
          selectedPhone = contact.phone;
          document.getElementById("chat-header").textContent = contact.phone;
          loadMessages(contact.phone);
        };
        ul.appendChild(li);
      });
    });
}

function loadContacts() {
  const ul = document.getElementById("contact-list");
  ul.innerHTML = "";

  fetch("/api/getContacts.php")
    .then(res => res.json())
    .then(contacts => {
      contacts.forEach(contact => {
        const li = document.createElement("li");
        li.style.cursor = "pointer";
        li.style.padding = "10px";
        li.style.borderBottom = "1px solid #ddd";

        li.innerHTML = `
          <strong>${contact.phone}</strong><br>
          <small>${contact.lastMessage || "Media/Document/Contact"}</small>
        `;

        li.onclick = () => {
          selectedPhone = contact.phone;
          document.getElementById("chat-header").textContent = contact.phone;
          loadMessages(contact.phone);
        };
        ul.appendChild(li);
      });
    });
}

