<?php
require_once 'db.php'; // contains $conn

function saveOrUpdateWhatsAppMessage($data, $auth, $origin) {
    global $conn;

    try {
        $stmt = $conn->prepare("INSERT INTO WhatsAppMessages 
            (fromPhoneNumber, messageId, messageType, text, timestamp, isRead) 
            VALUES (:fromPhoneNumber, :messageId, :messageType, :text, :timestamp, :isRead)");

        $stmt->execute([
            ':fromPhoneNumber' => $data['fromPhoneNumber'],
            ':messageId' => $data['messageId'] ?? null,
            ':messageType' => $data['messageType'],
            ':text' => $data['text'] ?? null,
            ':timestamp' => $data['timestamp'],
            ':isRead' => $data['isRead']
        ]);

        return [
            'status' => 'true',
            'returnedVal' => $conn->lastInsertId()
        ];

    } catch (Exception $e) {
        return [
            'status' => 'false',
            'error' => $e->getMessage()
        ];
    }
}

function saveOrUpdateContactData($data, $auth, $origin) {
    global $conn;
    try {
        $stmt = $conn->prepare("INSERT INTO WhatsAppContacts 
            (fromNumber, idWhatsAppMessage, wa_id, firstName, middleName, lastName, formattedName, company) 
            VALUES (:fromNumber, :idWhatsAppMessage, :wa_id, :firstName, :middleName, :lastName, :formattedName, :company)");

        $stmt->execute([
            ':fromNumber' => $data['fromNumber'],
            ':idWhatsAppMessage' => $data['idWhatsAppMessage'],
            ':wa_id' => $data['wa_id'],
            ':firstName' => $data['first_name'],
            ':middleName' => $data['middle_name'],
            ':lastName' => $data['last_name'],
            ':formattedName' => $data['formatted_name'],
            ':company' => $data['company']
        ]);

        return [
            'status' => 'true',
            'returnedVal' => $conn->lastInsertId()
        ];
    } catch (Exception $e) {
        return [
            'status' => 'false',
            'error' => $e->getMessage()
        ];
    }
}

function saveOrUpdatePhoneData($data, $auth, $origin) {
    global $conn;
    try {
        $stmt = $conn->prepare("INSERT INTO WhatsAppContactPhones 
            (idWhatsAppContact, phone, wa_id, type) 
            VALUES (:idWhatsAppContact, :phone, :wa_id, :type)");

        $stmt->execute([
            ':idWhatsAppContact' => $data['idWhatsAppContact'],
            ':phone' => $data['phone'],
            ':wa_id' => $data['wa_id'],
            ':type' => $data['type']
        ]);

        return ['status' => 'true'];
    } catch (Exception $e) {
        return [
            'status' => 'false',
            'error' => $e->getMessage()
        ];
    }
}


function saveOrUpdateWhatsAppMessageO($message, $auth, $origin) {
    global $conn;
    $stmt = null;

    if ($message['messageType'] === 'text') {
        $sql = "INSERT INTO WhatsAppMessages 
                (fromPhoneNumber, messageId, messageType, text, timestamp, isRead)
                VALUES (?, ?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sssssi",
            $message['fromPhoneNumber'],
            $message['messageId'],
            $message['messageType'],
            $message['text'],
            $message['timestamp'],
            $message['isRead']
        );
    } else {
        $sql = "INSERT INTO WhatsAppMessages 
                (fromPhoneNumber, messageId, timestamp, messageType, mediaId, mimeType, phoneNumberId, fileName, text, isRead)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $text = $message['text'] ?? null;
        $fileName = $message['fileName'] ?? null;
        $stmt->bind_param("sssssssssi",
            $message['fromPhoneNumber'],
            $message['messageId'],
            $message['timestamp'],
            $message['messageType'],
            $message['mediaId'],
            $message['mimeType'],
            $message['phoneNumberId'],
            $fileName,
            $text,
            $message['isRead']
        );
    }

    if ($stmt->execute()) {
        return [
            'status' => 'true',
            'returnedVal' => $stmt->insert_id
        ];
    } else {
        return [
            'status' => 'false',
            'error' => $stmt->error
        ];
    }
}
function saveOrUpdateContactDataO($contact, $auth, $origin) {
    global $conn;

    $sql = "INSERT INTO WhatsAppContacts 
            (fromNumber, idWhatsAppMessage, wa_id, firstName, middleName, lastName, formattedName, company)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sissssss",
        $contact['fromNumber'],
        $contact['idWhatsAppMessage'],
        $contact['wa_id'],
        $contact['first_name'],
        $contact['middle_name'],
        $contact['last_name'],
        $contact['formatted_name'],
        $contact['company']
    );

    if ($stmt->execute()) {
        return [
            'status' => 'true',
            'returnedVal' => $stmt->insert_id
        ];
    } else {
        return [
            'status' => 'false',
            'error' => $stmt->error
        ];
    }
}
function saveOrUpdatePhoneDataO($phoneData, $auth, $origin) {
    global $conn;

    $sql = "INSERT INTO WhatsAppContactPhones 
            (idWhatsAppContact, phone, wa_id, type)
            VALUES (?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("isss",
        $phoneData['idWhatsAppContact'],
        $phoneData['phone'],
        $phoneData['wa_id'],
        $phoneData['type']
    );

    if ($stmt->execute()) {
        return ['status' => 'true'];
    } else {
        return [
            'status' => 'false',
            'error' => $stmt->error
        ];
    }
}


?>