<?php

// -- CONFIGURATION --
$verify_token = "humans_token_123";

// DB connection (replace with your credentials)
$conn = new mysqli("localhost", "db_user", "db_password", "db_name");
if ($conn->connect_error) die("DB connection failed: " . $conn->connect_error);

// -- WEBHOOK VERIFICATION (GET) --
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $hubMode = $_GET['hub_mode'] ?? '';
    $hubChallenge = $_GET['hub_challenge'] ?? '';
    $hubVerifyToken = $_GET['hub_verify_token'] ?? '';

    if ($hubMode === 'subscribe' && $hubVerifyToken === $verify_token) {
        echo $hubChallenge;
    } else {
        http_response_code(403);
        echo "Verification failed: $hubVerifyToken";
    }
    exit;
}

// -- INCOMING MESSAGE HANDLER (POST) --
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $json = file_get_contents("php://input");
    file_put_contents("webhook_log.txt", date("Y-m-d H:i:s") . "\n" . $json . "\n\n", FILE_APPEND);

    $data = json_decode($json, true);

    if (!isset($data['entry'][0]['changes'][0]['value'])) {
        http_response_code(400);
        echo "Invalid payload.";
        exit;
    }

    $value = $data['entry'][0]['changes'][0]['value'];
    $phoneNumberId = $value['metadata']['phone_number_id'] ?? null;

    if (!isset($value['messages'])) {
        http_response_code(200);
        echo "No message to process.";
        exit;
    }

    foreach ($value['messages'] as $message) {
        $from = $message['from'];
        $messageId = $message['id'];
        $timestamp = date("Y-m-d H:i:s", $message['timestamp']);
        $type = $message['type'];

        $w = [
            'fromPhoneNumber' => $from,
            'messageId' => $messageId,
            'timestamp' => $timestamp,
            'messageType' => $type,
            'phoneNumberId' => $phoneNumberId,
        ];

        switch ($type) {
            case 'text':
                $w['text'] = $message['text']['body'] ?? '';
                updateData('whatsAppMessage', $w);
                break;

            case 'image':
            case 'video':
            case 'document':
                $media = $message[$type];
                $w['mediaId'] = $media['id'] ?? '';
                $w['mimeType'] = $media['mime_type'] ?? '';
                if ($type === 'document') {
                    $w['fileName'] = $media['filename'] ?? '';
                }
                updateData('whatsAppMessage', $w);
                break;

            case 'contacts':
                updateData('whatsAppMessage', $w);
                $idWhatsAppMessage = getLastInsertId($conn); // simulate getting inserted ID

                foreach ($message['contacts'] as $contact) {
                    $contactData = [
                        'wa_id' => $from,
                        'idWhatsAppMessage' => $idWhatsAppMessage,
                        'fromNumber' => $from,
                        'first_name' => $contact['name']['first_name'] ?? null,
                        'middle_name' => $contact['name']['middle_name'] ?? null,
                        'last_name' => $contact['name']['last_name'] ?? null,
                        'formatted_name' => $contact['name']['formatted_name'] ?? null,
                        'company' => $contact['org']['company'] ?? null
                    ];
                    updateData('whatsAppContact', $contactData);
                    $idWhatsAppContact = getLastInsertId($conn);

                    if (isset($contact['phones'])) {
                        foreach ($contact['phones'] as $phone) {
                            $phoneData = [
                                'idWhatsAppContact' => $idWhatsAppContact,
                                'phone' => $phone['phone'] ?? '',
                                'type' => $phone['type'] ?? 'MOBILE',
                                'wa_id' => $phone['wa_id'] ?? ''
                            ];
                            updateData('phoneData', $phoneData);
                        }
                    }
                }
                break;

            default:
                file_put_contents("webhook_log.txt", "Unhandled type: $type\n", FILE_APPEND);
                break;
        }
    }

    http_response_code(200);
    echo "Processed.";
}

// -- REUSABLE INSERT FUNCTION (Simulating updateData) --
function updateData($table, $data) {
    global $conn;

    $columns = implode(", ", array_keys($data));
    $values = implode("', '", array_map([$conn, 'real_escape_string'], array_values($data)));
    $query = "INSERT INTO $table ($columns) VALUES ('$values')";

    if (!$conn->query($query)) {
        file_put_contents("errors.txt", "DB Error [$table]: " . $conn->error . "\n", FILE_APPEND);
    }
}

// -- Simulated ID retrieval after insert --
function getLastInsertId($conn) {
    return $conn->insert_id;
}
?>
