<?php
// webhook.php
header("Content-Type: application/json");
require_once 'db.php'; // contains $conn
require_once 'functions.php'; // contains $conn

// ------------------ WEBHOOK VERIFICATION ------------------
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $mode = $_GET['hub_mode'] ?? '';
    $token = $_GET['hub_verify_token'] ?? '';
    $challenge = $_GET['hub_challenge'] ?? '';
    
    $graphtoken= getenv('GRAPH_API_TOKEN');

    if ($mode === 'subscribe' && $token === $graphtoken) {
        echo $challenge;
    } else {
        http_response_code(403);
        echo "Verification failed.";
    }
    exit;
}

// ------------------ WEBHOOK HANDLING ------------------
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $auth = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
    $origin = $_SERVER['HTTP_ORIGIN'] ?? '';

    if (isset($input['entry'])) {
        foreach ($input['entry'] as $entry) {
            foreach ($entry['changes'] as $change) {
                $value = $change['value'];
                $phoneNumberId = $value['metadata']['phone_number_id'];

                if (isset($value['messages'])) {
                    foreach ($value['messages'] as $message) {
                        $messageType = $message['type'];
                        $from = $message['from'];
                        $msgId = $message['id'];
                        $timestamp = date('Y-m-d H:i:s', $message['timestamp']);

                        $w = [
                            "fromPhoneNumber" => $from,
                            "messageId" => $msgId,
                            "timestamp" => $timestamp,
                            "messageType" => $messageType,
                            "phoneNumberId" => $phoneNumberId,
                            "isRead" => 0,
                        ];
 ensureLeadExists($w['fromPhoneNumber']);
                        switch ($messageType) {
                            case 'text':
                                $w['text'] = $message['text']['body'] ?? '';
                                $resp = saveOrUpdateWhatsAppMessage($w, $auth, $origin);
                                break;

                            // case 'image':
                            //     $w['mediaId'] = $message['image']['id'] ?? '';
                            //     $w['mimeType'] = $message['image']['mime_type'] ?? '';
                            //     saveOrUpdateWhatsAppMessage($w, $auth, $origin);
                            //     break;

                            // case 'video':
                            //     $w['mediaId'] = $message['video']['id'] ?? '';
                            //     $w['mimeType'] = $message['video']['mime_type'] ?? '';
                            //     saveOrUpdateWhatsAppMessage($w, $auth, $origin);
                            //     break;

                            // case 'document':
                            //     $w['mediaId'] = $message['document']['id'] ?? '';
                            //     $w['mimeType'] = $message['document']['mime_type'] ?? '';
                            //     $w['fileName'] = $message['document']['filename'] ?? '';
                            //     saveOrUpdateWhatsAppMessage($w, $auth, $origin);
                            //     break;

case 'image':
    $w['mediaId'] = null; // not available yet
    $w['mimeType'] = $message['image']['mime_type'] ?? '';
    $w['caption'] = $message['image']['caption'] ?? null;
    $w['isMediaResolved'] = 0;
    $w['text'] = $message['image']['caption'] ?? null;
    saveOrUpdateWhatsAppMessage($w, $auth, $origin);
    break;

case 'video':
    $w['mediaId'] = null;
    $w['mimeType'] = $message['video']['mime_type'] ?? '';
    $w['caption'] = $message['video']['caption'] ?? null;
    $w['isMediaResolved'] = 0;
    $w['text'] = $message['video']['caption'] ?? null;
    saveOrUpdateWhatsAppMessage($w, $auth, $origin);
    break;

case 'document':
    $w['mediaId'] = null;
    $w['mimeType'] = $message['document']['mime_type'] ?? '';
    $w['fileName'] = $message['document']['filename'] ?? '';
    $w['caption'] = $message['document']['caption'] ?? null;
    $w['isMediaResolved'] = 0;
    $w['text'] = $message['document']['caption'] ?? null;

    saveOrUpdateWhatsAppMessage($w, $auth, $origin);
    break;

                            case 'contacts':
                                $contact = $message['contacts'][0];
                                $resp = saveOrUpdateWhatsAppMessage($w, $auth, $origin);
                                if ($resp['status'] === 'true') {
                                    $w['idWhatsAppMessage'] = $resp['returnedVal'];

                                    $contactData = [
                                        "fromNumber" => $w['fromPhoneNumber'],
                                        "idWhatsAppMessage" => $w['idWhatsAppMessage'],
                                        "wa_id" => $from,
                                        "first_name" => $contact['name']['first_name'] ?? null,
                                        "middle_name" => $contact['name']['middle_name'] ?? null,
                                        "last_name" => $contact['name']['last_name'] ?? null,
                                        "formatted_name" => $contact['name']['formatted_name'] ?? null,
                                        "company" => $contact['org']['company'] ?? null
                                    ];

                                    $cResp = saveOrUpdateContactData($contactData, $auth, $origin);
                                    if ($cResp['status'] === 'true') {
                                        $phones = $contact['phones'] ?? [];
                                        foreach ($phones as $phone) {
                                            $phoneData = [
                                                "idWhatsAppContact" => $cResp['returnedVal'],
                                                "phone" => $phone['phone'],
                                                "type" => $phone['type'] ?? 'MOBILE',
                                                "wa_id" => $phone['wa_id'] ?? null
                                            ];
                                            saveOrUpdatePhoneData($phoneData, $auth, $origin);
                                        }
                                    }
                                }
                                break;

                            default:
                                error_log("Unhandled message type: $messageType");
                        }
                    }
                }
            }
        }
    }
    echo json_encode(["status" => "received"]);
    exit;
}

http_response_code(405);
echo "Method Not Allowed";
