<?php
// resolveMedia.php

require_once 'db.php';
date_default_timezone_set('Asia/Kolkata');
 $graphtoken= 'EAAONAxZCIHJUBPBfJgvKyEfIDwJnzp8Ju8tU9pFUtMwmxz5zjgvD9VwP2z89xLfXWhawCWjZCZAZBBT63I1pJAtNNmhHpRWZBAkGqeZCDZAZA14TLsoQwIuCcTFRwAUn5PpvRFOMOBavzUZClCf9ToISiOrgq5FsTXCd3DZBZAeagZA8GvftZCtDoFiik7sC38aRgyOWAHwZDZD';
 
define('ACCESS_TOKEN', 'humans_token_123'); // Replace with your actual token
echo "token--". $graphtoken."<br>";
function logError($msg) {
    error_log("[Media Resolver] " . $msg);
}

function getMediaIdFromMessage($messageId) {
    $url = "https://graph.facebook.com/v19.0/{$messageId}?fields=type,image,video,document&access_token=EAAONAxZCIHJUBPBfJgvKyEfIDwJnzp8Ju8tU9pFUtMwmxz5zjgvD9VwP2z89xLfXWhawCWjZCZAZBBT63I1pJAtNNmhHpRWZBAkGqeZCDZAZA14TLsoQwIuCcTFRwAUn5PpvRFOMOBavzUZClCf9ToISiOrgq5FsTXCd3DZBZAeagZA8GvftZCtDoFiik7sC38aRgyOWAHwZDZD" ;
    
    echo "<br>URL->". $url."<br>";
    $resp = file_get_contents($url);
    
    echo "Resp->". $resp."<br>";
    logError("📡 Response from message lookup for $messageId: $resp");
    
    if (!$resp) return null;

    $data = json_decode($resp, true);

    if (isset($data['image']['id'])) return $data['image']['id'];
    if (isset($data['video']['id'])) return $data['video']['id'];
    if (isset($data['document']['id'])) return $data['document']['id'];

    return null;
}

function getMediaUrl($mediaId) {
    $url = "https://graph.facebook.com/v18.0/{$mediaId}?access_token=" . $graphtoken;
    $resp = file_get_contents($url);

    if (!$resp) return null;

    $data = json_decode($resp, true);
    return $data['url'] ?? null;
}

function downloadFile($url, $fileName) {
    $dest = __DIR__ . '/../media/' . $fileName;
    $content = file_get_contents($url);
    if ($content) {
        file_put_contents($dest, $content);
        return true;
    }
    return false;
}

try {
    $stmt = $conn->query("SELECT idWhatsAppMessage, messageId, messageType FROM WhatsAppMessages WHERE isMediaResolved = 0 AND messageType IN ('image', 'video', 'document')");
    $messages = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($messages as $msg) {
        echo $msg;
        $mediaId = getMediaIdFromMessage($msg['messageId']);
        if (!$mediaId) {
            logError("❌ Failed to fetch mediaId for messageId {$msg['messageId']}");
            continue;
        }

        $mediaUrl = getMediaUrl($mediaId);
        if (!$mediaUrl) {
            logError("❌ Failed to get media URL for mediaId {$mediaId}");
            continue;
        }

        $ext = $msg['messageType'] === 'image' ? '.jpg' :
               ($msg['messageType'] === 'video' ? '.mp4' : '.pdf');

        $fileName = $mediaId . $ext;

        if (!downloadFile($mediaUrl, $fileName)) {
            logError("❌ Failed to download file for mediaId {$mediaId}");
            continue;
        }

        // Update DB
        $update = $conn->prepare("UPDATE WhatsAppMessages SET mediaId = ?, isMediaResolved = 1 WHERE idWhatsAppMessage = ?");
        $update->execute([$mediaId, $msg['idWhatsAppMessage']]);

        logError("✅ Media resolved for messageId {$msg['messageId']} → $fileName");
    }

    echo "🎉 Media resolution complete.";
} catch (Exception $e) {
    logError("❌ Exception: " . $e->getMessage());
    http_response_code(500);
    echo "Error occurred";
}
