<?php
// Database connection
$host = 'localhost';
$dbname = 'your_database_name';
$username = 'your_username';
$password = 'your_password';

$host = 'localhost';
$dbname = 'humansitcom_CRM2025';
$username = 'humansitcom_crm';
$password = 'mvNB.O.Lv.46Uj%{';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Could not connect to the database: " . $e->getMessage());
}

// Get filter parameters from GET request
$search = isset($_GET['search']) ? $_GET['search'] : '';
$brand = isset($_GET['brand']) ? $_GET['brand'] : '';
$type = isset($_GET['type']) ? $_GET['type'] : '';
$resolution = isset($_GET['resolution']) ? $_GET['resolution'] : '';
$min_price = isset($_GET['min_price']) ? $_GET['min_price'] : '';
$max_price = isset($_GET['max_price']) ? $_GET['max_price'] : '';
$sort = isset($_GET['sort']) ? $_GET['sort'] : 'price_asc';

// Build the SQL query with filters
$sql = "SELECT * FROM products WHERE 1=1";
$params = [];

if (!empty($search)) {
    $sql .= " AND (brand LIKE :search OR model_number LIKE :search OR description LIKE :search OR features LIKE :search)";
    $params[':search'] = "%$search%";
}

if (!empty($brand)) {
    $sql .= " AND brand = :brand";
    $params[':brand'] = $brand;
}

if (!empty($type)) {
    $sql .= " AND type = :type";
    $params[':type'] = $type;
}

if (!empty($resolution)) {
    $sql .= " AND resolution = :resolution";
    $params[':resolution'] = $resolution;
}

if (!empty($min_price)) {
    $sql .= " AND price >= :min_price";
    $params[':min_price'] = $min_price;
}

if (!empty($max_price)) {
    $sql .= " AND price <= :max_price";
    $params[':max_price'] = $max_price;
}

// Add sorting
switch ($sort) {
    case 'price_asc':
        $sql .= " ORDER BY price ASC";
        break;
    case 'price_desc':
        $sql .= " ORDER BY price DESC";
        break;
    case 'name_asc':
        $sql .= " ORDER BY brand ASC, model_number ASC";
        break;
    case 'name_desc':
        $sql .= " ORDER BY brand DESC, model_number DESC";
        break;
    default:
        $sql .= " ORDER BY price ASC";
}

// Prepare and execute the query
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Get unique values for filter dropdowns
$brands = $pdo->query("SELECT DISTINCT brand FROM products ORDER BY brand")->fetchAll(PDO::FETCH_COLUMN);
$types = $pdo->query("SELECT DISTINCT type FROM products WHERE type IS NOT NULL ORDER BY type")->fetchAll(PDO::FETCH_COLUMN);
$resolutions = $pdo->query("SELECT DISTINCT resolution FROM products WHERE resolution IS NOT NULL ORDER BY resolution")->fetchAll(PDO::FETCH_COLUMN);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Product Catalog</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .product-card {
            transition: transform 0.2s;
            margin-bottom: 20px;
            height: 100%;
        }
        .product-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        }
        .card-img-top {
            height: 200px;
            object-fit: contain;
            background-color: #f8f9fa;
        }
        .filter-section {
            background-color: #f8f9fa;
            padding: 20px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .price-range {
            display: flex;
            gap: 10px;
        }
        .price-range input {
            flex: 1;
        }
    </style>
</head>
<body>
    <div class="container py-4">
        <h1 class="mb-4">Product Catalog</h1>
        
        <!-- Filter Section -->
        <div class="filter-section mb-4">
            <form method="get" action="">
                <div class="row g-3">
                    <div class="col-md-4">
                        <label for="search" class="form-label">Search</label>
                        <input type="text" class="form-control" id="search" name="search" placeholder="Search products..." value="<?= htmlspecialchars($search) ?>">
                    </div>
                    <div class="col-md-2">
                        <label for="brand" class="form-label">Brand</label>
                        <select class="form-select" id="brand" name="brand">
                            <option value="">All Brands</option>
                            <?php foreach ($brands as $b): ?>
                                <option value="<?= htmlspecialchars($b) ?>" <?= $brand === $b ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($b) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label for="type" class="form-label">Type</label>
                        <select class="form-select" id="type" name="type">
                            <option value="">All Types</option>
                            <?php foreach ($types as $t): ?>
                                <option value="<?= htmlspecialchars($t) ?>" <?= $type === $t ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($t) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label for="resolution" class="form-label">Resolution</label>
                        <select class="form-select" id="resolution" name="resolution">
                            <option value="">All Resolutions</option>
                            <?php foreach ($resolutions as $r): ?>
                                <option value="<?= htmlspecialchars($r) ?>" <?= $resolution === $r ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($r) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label for="sort" class="form-label">Sort By</label>
                        <select class="form-select" id="sort" name="sort">
                            <option value="price_asc" <?= $sort === 'price_asc' ? 'selected' : '' ?>>Price: Low to High</option>
                            <option value="price_desc" <?= $sort === 'price_desc' ? 'selected' : '' ?>>Price: High to Low</option>
                            <option value="name_asc" <?= $sort === 'name_asc' ? 'selected' : '' ?>>Name: A to Z</option>
                            <option value="name_desc" <?= $sort === 'name_desc' ? 'selected' : '' ?>>Name: Z to A</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Price Range</label>
                        <div class="price-range">
                            <input type="number" class="form-control" placeholder="Min" name="min_price" value="<?= htmlspecialchars($min_price) ?>">
                            <input type="number" class="form-control" placeholder="Max" name="max_price" value="<?= htmlspecialchars($max_price) ?>">
                        </div>
                    </div>
                    <div class="col-md-2 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary w-100">Apply Filters</button>
                    </div>
                    <div class="col-md-2 d-flex align-items-end">
                        <a href="?" class="btn btn-outline-secondary w-100">Reset</a>
                    </div>
                </div>
            </form>
        </div>

        <!-- Results Count -->
        <div class="mb-3">
            <strong><?= count($products) ?></strong> products found
        </div>

        <!-- Product Grid -->
        <div class="row">
            <?php if (empty($products)): ?>
                <div class="col-12">
                    <div class="alert alert-info">No products found matching your criteria.</div>
                </div>
            <?php else: ?>
                <?php foreach ($products as $product): ?>
                    <div class="col-md-4 col-lg-3">
                        <div class="card product-card">
                            <!-- Placeholder for product image - in a real app you would use actual product images -->
                            <div class="card-img-top bg-light d-flex align-items-center justify-content-center">
                                <span class="text-muted">Product Image</span>
                            </div>
                            <div class="card-body">
                                <h5 class="card-title"><?= htmlspecialchars($product['brand']) ?> <?= htmlspecialchars($product['model_number']) ?></h5>
                                <h6 class="card-subtitle mb-2 text-muted"><?= htmlspecialchars($product['type']) ?></h6>
                                <div class="mb-2">
                                    <?php if (!empty($product['resolution'])): ?>
                                        <span class="badge bg-primary"><?= htmlspecialchars($product['resolution']) ?></span>
                                    <?php endif; ?>
                                    <?php if (!empty($product['wdr'])): ?>
                                        <span class="badge bg-success"><?= htmlspecialchars($product['wdr']) ?></span>
                                    <?php endif; ?>
                                    <?php if (!empty($product['ip_rating'])): ?>
                                        <span class="badge bg-info"><?= htmlspecialchars($product['ip_rating']) ?></span>
                                    <?php endif; ?>
                                </div>
                                <p class="card-text text-truncate" title="<?= htmlspecialchars($product['description']) ?>">
                                    <?= htmlspecialchars($product['description']) ?>
                                </p>
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="fw-bold">₹<?= number_format($product['price'], 2) ?></span>
                                    <a href="#" class="btn btn-sm btn-outline-primary">Details</a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>