<?php
require_once 'db.php'; // adjust path if needed

header("Content-Type: application/json");

$mobile = $_GET['mobile'] ?? '';
$page = intval($_GET['page'] ?? 1);
$limit = 20;
$offset = ($page - 1) * $limit;

if (empty($mobile)) {
    echo json_encode(['status' => 'false', 'error' => 'Mobile number is required']);
    exit;
}

try {
    $stmt = $conn->prepare("
        SELECT idWhatsAppMessage, fromPhoneNumber, messageType, text, timestamp, isRead
        FROM WhatsAppMessages
        WHERE fromPhoneNumber = :mobile OR toPhoneNumber = :mobile
        ORDER BY timestamp DESC
        LIMIT :limit OFFSET :offset
    ");
    $stmt->bindParam(':mobile', $mobile);
    $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    $stmt->execute();

    $messages = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(['status' => 'true', 'data' => $messages]);

} catch (Exception $e) {
    echo json_encode(['status' => 'false', 'error' => $e->getMessage()]);
}
