<?php
header('Content-Type: application/json');
require_once 'db.php';
$limit = isset($_GET['limit']) ? intval($_GET['limit']) : 30;
$offset = isset($_GET['offset']) ? intval($_GET['offset']) : 0;
$search = isset($_GET['search']) ? trim($_GET['search']) : '';

try {
    $query = "SELECT idLead, fullName, mobile FROM Leads";
    $params = [];

    if ($search !== '') {
        $query .= " WHERE fullName LIKE :search OR mobile LIKE :search";
        $params[':search'] = '%' . $search . '%';
    }

    $query .= " ORDER BY idLead DESC LIMIT :limit OFFSET :offset";

    $stmt = $conn->prepare($query);

    // Bind values
    if ($search !== '') {
        $stmt->bindValue(':search', $params[':search'], PDO::PARAM_STR);
    }
    $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);

    $stmt->execute();
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'status' => 'true',
        'data' => $results
    ]);
} catch (PDOException $e) {
    echo json_encode([
        'status' => 'false',
        'error' => $e->getMessage()
    ]);
}
?>
