<?php
require_once 'db.php'; // contains $conn

function saveOrUpdateWhatsAppMessage($data, $auth, $origin) {
    global $conn;

    try {
        $stmt = $conn->prepare("INSERT INTO WhatsAppMessages 
            (fromPhoneNumber, messageId, messageType, text, timestamp, isRead) 
            VALUES (:fromPhoneNumber, :messageId, :messageType, :text, :timestamp, :isRead)");

        $stmt->execute([
            ':fromPhoneNumber' => $data['fromPhoneNumber'],
            ':messageId' => $data['messageId'] ?? null,
            ':messageType' => $data['messageType'],
            ':text' => $data['text'] ?? null,
            ':timestamp' => $data['timestamp'],
            ':isRead' => $data['isRead']
        ]);

        return [
            'status' => 'true',
            'returnedVal' => $conn->lastInsertId()
        ];

    } catch (Exception $e) {
        return [
            'status' => 'false',
            'error' => $e->getMessage()
        ];
    }
}

function saveOrUpdateContactData($data, $auth, $origin) {
    global $conn;
    try {
        $stmt = $conn->prepare("INSERT INTO WhatsAppContacts 
            (fromNumber, idWhatsAppMessage, wa_id, firstName, middleName, lastName, formattedName, company) 
            VALUES (:fromNumber, :idWhatsAppMessage, :wa_id, :firstName, :middleName, :lastName, :formattedName, :company)");

        $stmt->execute([
            ':fromNumber' => $data['fromNumber'],
            ':idWhatsAppMessage' => $data['idWhatsAppMessage'],
            ':wa_id' => $data['wa_id'],
            ':firstName' => $data['first_name'],
            ':middleName' => $data['middle_name'],
            ':lastName' => $data['last_name'],
            ':formattedName' => $data['formatted_name'],
            ':company' => $data['company']
        ]);

        return [
            'status' => 'true',
            'returnedVal' => $conn->lastInsertId()
        ];
    } catch (Exception $e) {
        return [
            'status' => 'false',
            'error' => $e->getMessage()
        ];
    }
}

function saveOrUpdatePhoneData($data, $auth, $origin) {
    global $conn;
    try {
        $stmt = $conn->prepare("INSERT INTO WhatsAppContactPhones 
            (idWhatsAppContact, phone, wa_id, type) 
            VALUES (:idWhatsAppContact, :phone, :wa_id, :type)");

        $stmt->execute([
            ':idWhatsAppContact' => $data['idWhatsAppContact'],
            ':phone' => $data['phone'],
            ':wa_id' => $data['wa_id'],
            ':type' => $data['type']
        ]);

        return ['status' => 'true'];
    } catch (Exception $e) {
        return [
            'status' => 'false',
            'error' => $e->getMessage()
        ];
    }
}

function ensureLeadExists($mobile, $name = null) {
    global $conn;
    try {
        $stmt = $conn->prepare("SELECT idLead FROM Leads WHERE mobile = ?");
        $stmt->execute([$mobile]);

        if ($stmt->rowCount() === 0) {
            $insert = $conn->prepare("INSERT INTO Leads (fullName, mobile, leadFor, InformationPassed, IsClient)
                                      VALUES (?, ?, 'WhatsApp', 'Auto-added via webhook', 0)");
            $insert->execute([$name ?? 'WhatsApp Lead', $mobile]);
            error_log("New lead inserted for mobile: $mobile");
            return true;
        } else {
            return false; // Lead already exists
        }
    } catch (Exception $e) {
        error_log("Error in ensureLeadExists: " . $e->getMessage());
        return false;
    }
}


?>