<?php
require_once 'db.php'; // contains $conn
require_once 'graph_helper.php'; // must contain function to download media from Graph API


if (!isset($_GET['id'])) {
    http_response_code(400);
    echo "Missing media ID.";
    exit;
}

$mediaId = $_GET['id'];
$accessToken = 'EAAONAxZCIHJUBPBfJgvKyEfIDwJnzp8Ju8tU9pFUtMwmxz5zjgvD9VwP2z89xLfXWhawCWjZCZAZBBT63I1pJAtNNmhHpRWZBAkGqeZCDZAZA14TLsoQwIuCcTFRwAUn5PpvRFOMOBavzUZClCf9ToISiOrgq5FsTXCd3DZBZAeagZA8GvftZCtDoFiik7sC38aRgyOWAHwZDZD'; // Replace with actual token or load from secure config

// Step 1: Get the media URL
$mediaUrlEndpoint = "https://graph.facebook.com/v19.0/$mediaId";
$headers = [
    "Authorization: Bearer $accessToken"
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $mediaUrlEndpoint);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

$result = json_decode($response, true);
if (!isset($result['url'])) {
    http_response_code(500);
    echo "Failed to retrieve media URL.";
    exit;
}

$mediaUrl = $result['url'];

// Step 2: Download and output the media
$ch2 = curl_init();
curl_setopt($ch2, CURLOPT_URL, $mediaUrl);
curl_setopt($ch2, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch2, CURLOPT_HEADER, true);
$response = curl_exec($ch2);
$header_size = curl_getinfo($ch2, CURLINFO_HEADER_SIZE);
$header = substr($response, 0, $header_size);
$body = substr($response, $header_size);
curl_close($ch2);

// Extract content-type
if (preg_match('/Content-Type:\s*([^\s]+)/i', $header, $matches)) {
    $contentType = $matches[1];
    header("Content-Type: $contentType");
}

echo $body;
exit;